﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Visifire.Charts;

namespace ZoomingWithMultipleCharts
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            MyChart1.AxesX[0].OnZoom += new EventHandler<AxisZoomEventArgs>(MyChart1_OnZoom);
            MyChart2.AxesX[0].OnZoom += new EventHandler<AxisZoomEventArgs>(MyChart2_OnZoom);

            MyChart1.AxesX[0].Scroll += new EventHandler<AxisScrollEventArgs>(MyChart1_Scroll);
            MyChart2.AxesX[0].Scroll += new EventHandler<AxisScrollEventArgs>(MyChart2_Scroll);
        }

        void MyChart1_Scroll(object sender, AxisScrollEventArgs e)
        {
            Axis axis = sender as Axis;
            MyChart2.AxesX[0].ScrollBarOffset = axis.ScrollBarOffset;
        }

        void MyChart2_Scroll(object sender, AxisScrollEventArgs e)
        {
            Axis axis = sender as Axis;
            MyChart1.AxesX[0].ScrollBarOffset = axis.ScrollBarOffset;
        }

        void MyChart1_OnZoom(object sender, AxisZoomEventArgs e)
        {
            Axis axis = sender as Axis;
            MyChart2.AxesX[0].Zoom(e.MaxValue, e.MinValue);
            MyChart2.AxesX[0].ScrollBarOffset = axis.ScrollBarOffset;
        }

        void MyChart2_OnZoom(object sender, AxisZoomEventArgs e)
        {
            Axis axis = sender as Axis;
            MyChart1.AxesX[0].Zoom(e.MaxValue, e.MinValue);
            MyChart1.AxesX[0].ScrollBarOffset = axis.ScrollBarOffset;
        }

        Random rand = new Random(DateTime.Now.Millisecond);
    }
}
